<?php
// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}



function coppermine_admin_menu() {
    // Top-level menu
    add_menu_page(
        'CoppermineSC Reloaded',                  // Page title
        'CPGSC Reloaded',                  // Menu title
        'manage_options',                // Capability
        'coppermine-sc',                 // Slug
        'coppermine_settings_page',      // Callback for default page
        'dashicons-images-alt2',      // Icon
        66                               // Position (right under Plugins)
    );

    // Submenu: Settings
    add_submenu_page(
        'coppermine-sc',                 // Parent slug
        'CoppermineSC Reloaded Settings',         // Page title
        'Settings',                      // Menu title
        'manage_options',                // Capability
        'coppermine-sc',                 // Slug (same as top-level, so this becomes the default page)
        'coppermine_settings_page'       // Callback
    );

    // Submenu: Shortcode Guide
    add_submenu_page(
        'coppermine-sc',                 // Parent slug
        'CoppermineSC Reloaded Shortcode Guide',  // Page title
        'Shortcode Guide',               // Menu title
        'manage_options',                // Capability
        'coppermine-sc-shortcodes',      // Slug
        'coppermine_shortcode_guide_page'// Callback
    );
}
add_action('admin_menu', 'coppermine_admin_menu');



function coppermine_settings_page() {
    ?>
    <div class="wrap">
        <h1>CoppermineSC Reloaded Settings</h1>
        <form method="post" action="options.php">
            <?php
            settings_fields('coppermine_sc_options_group');
            do_settings_sections('coppermine-sc-reloaded-settings');
            submit_button();
            ?>
        </form>
        <center> <u>Looking for more options? go <a href=" https://feelinalive.net/shop/downloads/copperminesc-reloaded-pro/"><b>PRO</b></a>!</u></center>
		
    </div>
    <?php
}
add_action('admin_init', 'coppermine_settings_init');

function coppermine_settings_init() {
register_setting('coppermine_sc_options_group', 'coppermine_db_host');
    register_setting('coppermine_sc_options_group', 'coppermine_db_user');
    register_setting('coppermine_sc_options_group', 'coppermine_db_pass');
    register_setting('coppermine_sc_options_group', 'coppermine_db_name');
     register_setting('coppermine_sc_options_group', 'coppermine_table_prefix');
     register_setting('coppermine_sc_options_group', 'coppermine_gallery_domain');
    register_setting('coppermine_sc_options_group', 'coppermine_gallery_home');
    register_setting('coppermine_sc_options_group', 'coppermine_gallery_folder');
    register_setting('coppermine_sc_options_group', 'coppermine_gallery_albums_folder');
    register_setting('coppermine_sc_options_group', 'coppermine_display_tooltip');
    register_setting('coppermine_sc_options_group', 'coppermine_show_album_title');
register_setting('coppermine_sc_options_group', 'coppermine_show_album_title', 'cpgsc_sanitize_checkbox');




    add_settings_section(
        'coppermine_sc_main_section',
        'Database & Gallery Settings',
        null,
        'coppermine-sc-reloaded-settings'
    );
    
    add_settings_field('db_host', 'Database Host', 'coppermine_db_host_render', 'coppermine-sc-reloaded-settings', 'coppermine_sc_main_section');
    add_settings_field('db_user', 'Database User', 'coppermine_db_user_render', 'coppermine-sc-reloaded-settings', 'coppermine_sc_main_section');
    add_settings_field('db_pass', 'Database Password', 'coppermine_db_pass_render', 'coppermine-sc-reloaded-settings', 'coppermine_sc_main_section');
    add_settings_field('db_name', 'Database Name', 'coppermine_db_name_render', 'coppermine-sc-reloaded-settings', 'coppermine_sc_main_section');
     add_settings_field('db_table_prefix', 'Database Table Prefix', 'coppermine_table_prefix_render', 'coppermine-sc-reloaded-settings', 'coppermine_sc_main_section');
    add_settings_field('db_gallery_home', 'Gallery Home', 'coppermine_gallery_home_render', 'coppermine-sc-reloaded-settings', 'coppermine_sc_main_section');
     add_settings_field('db_gallery_domain', 'Gallery Domain', 'coppermine_gallery_domain_render', 'coppermine-sc-reloaded-settings', 'coppermine_sc_main_section');
      add_settings_field('db_gallery_folder', 'Gallery Folder Location', 'coppermine_gallery_folder_render', 'coppermine-sc-reloaded-settings', 'coppermine_sc_main_section');
     add_settings_field('db_gallery_albums_folder', 'Gallery Albums Folder Location', 'coppermine_gallery_albums_folder_render', 'coppermine-sc-reloaded-settings', 'coppermine_sc_main_section');
     add_settings_field(
    'display_tooltip_mode',
    'Latest Images Tooltip Display Content',
    'coppermine_display_tooltip_render',
    'coppermine-sc-reloaded-settings',
    'coppermine_sc_main_section'
);

add_settings_field(
    'coppermine_show_album_title',
    'Show Album Title Above Thumbnails',
    'coppermine_show_album_title_render',
    'coppermine-sc-reloaded-settings',
    'coppermine_sc_main_section'
);

}
function coppermine_db_host_render() {
    $value = esc_attr(get_option('coppermine_db_host', 'localhost'));
    echo "<input type='text' name='coppermine_db_host' value='$value' />";
    echo "<p class='description'>Default is 'localhost', change if your database is hosted elsewhere, leave empty if not.</p>";
}

function coppermine_db_user_render() {
    $value = esc_attr(get_option('coppermine_db_user'));
    echo "<input type='text' name='coppermine_db_user' value='$value' />";
     echo "<p class='description'>Enter the MySQL username for your Coppermine database.</p>";
}

function coppermine_db_pass_render() {
    $value = esc_attr(get_option('coppermine_db_pass'));
    echo "<input type='password' name='coppermine_db_pass' value='$value' />";
        echo "<p class='description'>Enter the MySQL password. This will be stored securely.</p>";
}

function coppermine_db_name_render() {
    $value = esc_attr(get_option('coppermine_db_name'));
    echo "<input type='text' name='coppermine_db_name' value='$value' />";
        echo "<p class='description'>The name of the database where Coppermine is installed.</p>";
}

function coppermine_table_prefix_render() {
    $value = esc_attr(get_option('coppermine_table_prefix'));
    echo "<input type='text' name='coppermine_table_prefix' value='$value' />";
        echo "<p class='description'>The prefix of your CPG table in your database ie 'cpg15x_'</p>";
}



function coppermine_gallery_home_render() {
    $value = esc_attr(get_option('coppermine_gallery_home'));
    echo "<input type='text' name='coppermine_gallery_home' value='$value' />";
    echo "<p class='description'>The URL of your gallery, ie. https://yoursite.com/gallery</p>";

}
function coppermine_gallery_domain_render() {
    $value = esc_attr(get_option('coppermine_gallery_domain'));
    echo "<input type='text' name='coppermine_gallery_domain' value='$value' />";
    echo "<p class='description'>The domain your gallery is on without the folder. ie. https://yoursite.com/</p>";

}

function coppermine_gallery_folder_render() {
    $value = esc_attr(get_option('coppermine_gallery_folder'));
    echo "<input type='text' name='coppermine_gallery_folder' value='$value' />";
    echo "<p class='description'>The path to your gallery's folder on your server typically the folder at the end of your gallery's URL ie. https://yoursite.com/gallery would be '/gallery' (include prefix slash)  </p>";

}

function coppermine_gallery_albums_folder_render() {
    $value = esc_attr(get_option('coppermine_gallery_albums_folder'));
    echo "<input type='text' name='coppermine_gallery_albums_folder' value='$value' />";
    echo "<p class='description'>The path to your gallery's albums folder typically something like '/gallery/albums/' (include slashes) </p>";

}
function coppermine_display_tooltip_render() {
    $value = get_option('coppermine_display_tooltip', 'album');
    ?>
    <select name="coppermine_display_tooltip">
        <option value="album" <?php selected($value, 'album'); ?>>Album Title</option>
        <option value="views" <?php selected($value, 'views'); ?>>Image Views</option>
    </select>
    <p class="description">Choose whether to show the album name or image view count as the image tooltip used in latest images if your theme supports qTips.</p>
    <?php
}

function coppermine_show_album_title_render() {
    $value = get_option('coppermine_show_album_title', '1'); // Default to checked
    echo '<input type="checkbox" name="coppermine_show_album_title" value="1" ' . checked(1, $value, false) . ' />';
    echo '<p class="description">Leave checked to display album title above thumbnails using "cpg_albumrand" and "cpg_albumnew"</p>';
}

// Checkbox sanitization
function cpgsc_sanitize_checkbox($input) {
    return $input === '1' ? '1' : '0';
}

function coppermine_shortcode_guide_page() {
    ?>
    <div class="wrap">
        <h1>Shortcode Guide</h1>
		Shortcodes are to be used in the pages and posts and the PHP code is to be used in the header.php and sidebar.php file. 
		  <table class="widefat striped">
        <h2>Classic Shortcodes</h2>
		<i>These shortcodes & functions were included in the original CoppermineSC plugin and should convert automatically.</i>
            <thead>
                <tr>
                    <th>Function</th>
                    <th>Shortcode</th>
                    <th>PHP Code</th>
                </tr>
            </thead>
            <tbody>
                <tr>
<td>Displays x amount of thumbnails from album x with optional album title before, can be used without number to display all thumbnails in album</td>
<td><code>[cpg_album:ALBUMID]</code> OR <code>[cpg_album:ALBUMID,NUMBER]</code></td>
<td><CODE>&lt;?php
echo cpgsc_render_album_thumbs(ALBUMID, null, 'pid ASC', '');
	// displays all thumbnails from album, format is (ALBUMID)
?></CODE><BR> OR <BR>
<CODE>&lt;?php
echo cpgsc_render_album_thumbs(ALBUMID, NUMBER, 'pid ASC', '');
	// displays all thumbnails from album, format is (ALBUMID,NUMBER)
?></CODE></td>
</tr>
<tr>
<td>Displays x amount of the most recently added images from album x with optional album title before, can be used without number to display all thumbnails in album</td>
<td><code>[cpg_albumnew:ALBUMID]</code> OR <code>[cpg_albumnew:ALBUMID,NUMBER]</code></td>
<td><code>&lt;?php
echo cpgsc_render_album_thumbs(ALBUMID, NUMBER, 'pid DESC', 'Recent');
	// displays the last uploaded thumbnails from album, format is (ALBUMID, NUMBER, 'pid DESC', 'Recent')
?></code></td>
</tr>
<tr>
<td>Displays x amount of random thumbnails from album x with optional album title before, can be used without number to display all thumbnails in album</td>
<td><code>[cpg_albumrand:ALBUMID]</code> OR <code>[cpg_albumrand:ALBUMID,NUMBER]</code></td>
<td><CODE>&lt;?php
echo cpgsc_render_album_thumbs(ALBUMID, NUMBER, 'RAND()', 'Random');
	// displays random thumbnails from album, format is (ALBUMID, NUMBER, 'RAND()', 'Random')
?></CODE></td>
</tr>
<tr>
<td>Displays x amount of thumbnails from category x, can be used without number to display all thumbnails in category</td>
<td><code>[cpg_cat:CATID]</code> OR <code>[cpg_cat:CATID,NUMBER]</code></td>
<td><CODE>&lt;?php echo cpgsc_render_category_images(CATID, null, 'pid ASC'); // displays thumbnail of images in CATID, format is (CATID, null, 'pid DESC') ?>
</CODE><BR>
OR <BR>
<code>&lt;?php echo cpgsc_render_category_images(CATID, NUMBER, 'pid ASC'); // displays thumbnail of images in CATID, format is (CATID, NUMBER, 'pid DESC') ?></code></td>
</tr>
<td>Displays x amount of thumbnails of the most recently added images from category x, can be used without number to display all thumbnails in category</td>
<td><code>[cpg_catnew:CATID]</code> OR <code>[cpg_catnew:CATID,NUMBER]</code></td>
<td><CODE>&lt;?php echo cpgsc_render_category_images(CATID, null, 'pid DESC'); // displays thumbnail of images in CATID, format is (CATID, null, 'pid DESC') ?>
</CODE><BR>
OR <BR>
<code>&lt;?php echo cpgsc_render_category_images(CATID, NUMBER, 'pid DESC'); // displays thumbnail of images in CATID, format is (CATID, NUMBER, 'pid DESC') ?></code></td>
</tr>
<tr>
<td>Displays x amount of random thumbnails from category x, can be used without number to display all thumbnails in category</td>
<td><code>[cpg_catrand:CATID]</code> OR <code>[cpg_catrand:CATID,NUMBER]</code></td>
<td><CODE>&lt;?php echo cpgsc_render_category_images(CATID, null, 'RAND()'); // displays thumbnail of images in CATID, format is (CATID, null, 'pid DESC') ?>
</CODE><BR>
OR <BR>
<code>&lt;?php echo cpgsc_render_category_images(CATID, NUMBER, 'RAND()'); // displays thumbnail of images in CATID, format is (CATID, NUMBER, 'pid DESC') ?></code></td>
</tr>
<tr>
<td>Displays x amount of random thumbnails from from the entire gallery</td>
<td><code>[cpg_galrand:NUMBER]</code></td>
<td><CODE>&lt;?php echo cpgsc_render_gallery_random(NUMBER); // displays x amount of random thumbnails from the entire gallery ?>
</CODE>
</td>
</tr>
            </tbody>
        </table>
        <table class="widefat striped">
       <h2>Classic Shortcodes - Rewritten</h2>
		<i>These functions are in the original plugin but have been rewritten for CPPGSC Reloaded. Old shortcodes used will need to be updated. </i>
               <thead>
                <tr>
                    <th>Function</th>
                    <th style="width: 33%">Shortcode</th>
                    <th>PHP Code</th>
                </tr>
            </thead>
            <tbody>
            <tr>
<td>Displays single thumbnail of the image with the picture ID x.</td>
<td>Old Version Shortcode: <code>[cpg_imagefixthumb:PID]</code><BR>
New Version Shortcode:	
<code>[cpg_thumb:PID]</code></td>
<td><CODE>&lt;?php
echo cpgsc_get_image_by_pid(piD, 'thumb');
	// displays thumbnail of image, format is (PID, 'thumb')
?></CODE></td>
</tr>
<tr>
<td>Displays single normal version of the image with the picture ID x.</td>
<td>
Old Version Shortcode: <code>cpg_imagefixnormal:PID]</code><BR>
New Version Shortcode:
<code>[cpg_normal:PID]</code></td>
<td><CODE>&lt;?php
echo cpgsc_get_image_by_pid(piD, 'normal');
	// displays thumbnail of image, format is (PID, 'normal')
?></CODE></td>
</tr>
<tr>
<td>Displays single full image  with the picture ID x.</td>
<td>Old Version Shortcode: <code>[cpg_imagefix:PID]</code> <BR>
New Version Shortcode:
<code>[cpg_image:PID]</code></td>
<td><CODE>&lt;?php
echo cpgsc_get_image_by_pid(piD, 'image');
	// displays thumbnail of image, format is (PID, 'thumb')
?></CODE></td>
</tr>
<tr>
<td>Displays the latest x amount of photos added to the gallery</td>
<td>Old Version Shortcode : <code>[cpg_galnew:NUMBER]</code> <BR>
New Version Shortcode: <code>[cpg_latestimages:NUMBER]</code></td>
<td><code>&lt;?php
echo cpgsc_latest_images_render(NUMBER);
// displays x amount of latest images 
?></code></td>
</tr>
</tbody>
</table>
 <table class="widefat striped">
      <h2>New Shortcodes</h2>
		<i>These shortcodes are new in CPGSC Reloaded and not included in the original plugin. </i>

               <thead>
                <tr>
                    <th>Function</th>
                    <th>Shortcode</th>
                    <th>PHP Code</th>
                </tr>
            </thead>
            <tbody>
            <tr>
<td>Display x amount of latest albums added to the entire gallery</td>
<td><code>[cpg_latestalbumsall:NUMBER]</code></td>
<td><code>&lt;?php
echo cpgsc_display_recent_albums(null, NUMBER);
	// displays the lastest albums added to the entire gallery with image count and date, format is (null, NUMBER)
?></code></td>
</tr>
</tr>
<tr>
<td>Display x amount of latest albums added to cartegory x (includes sub-categories) with image count and date</td>
<td><Code>[cpg_latestalbums:CATID,NUMBER]</Code></td>
<td><code>&lt;?php
echo cpgsc_display_recent_albums(CATID, NUMBER);
	// displays the lastest albums added to specific category (includes sub-categories) with image count and date, format is (CATID, NUMBER)
?></code></td>
</tr>
<tr>
<td>Displays the text "Latest Albums in the Gallery" followed by a list of the the latest x amount of albums with their last upload date</td>
<td><code>[cpg_latestalbumsalltext:NUMBER]</code></td>
<td><code>&lt;?php
echo cpgsc_display_latest_albums_text(NUMBER);
	// displays text album links for the last x amount of albums added to the enitre gallery
?></code></td>
</tr>
<tr>
<td>Displays the text "Latest Ablums in MAIN CATEGORY" (will be the main category ID input) in category x followed by a list of the x amount of latest albums added with their category listed before the album and the last upload date listed after. This will include the main category's child categories. </td>
<td><code>[cpg_latestalbumstext:CATID,NUMBER]</code></td>
<td><code>&lt;?php
echo cpgsc_display_latest_albums_by_category_text(CATID, NUMBER);
	// displays text album links from specific category, format is (CATID,NUMBER) 
?></code></td>
</tr>
<tr>
<td>Displays the breadcrumb category trail to the album followed by the linked album name</td>
<td><code>[cpg_albumlink:ALBUMID]</code></td>
<td><code>&lt;?php
echo cpgsc_render_album_breadcrumb(ALBUMID);
	// displays breadcrumb link to album format is (ALBUMID)
?></code></td>
</tr>
<tr>
<td>Displays list of gallery statisics including number of albums, images, categories, total image view count and last updated date</td>
<td><code>[cpg_gallerystats]</code></td>
<td><code>&lt;?php
echo cpgsc_get_gallery_stats();
	// displays list of gallery statisics including number of albums, images. categories, total image view count and last updated date
?></code></td>
</tr>
<tr>
<td>Displays sentence with gallery statisics including number of albums, images, categories, total image view count and last updated date</td>
<td><code>[cpg_gallerystatsshort]</code></td>
<td><code>&lt;?php
echo cpgsc_get_gallery_stats_short();
	// displays a sentence with the gallery statisics including number of albums, images. categories, total image view count and last updated date
?></code></td>
</tr>
</tbody>
</table>
<center> <u>Looking for more options? go <a href=" https://feelinalive.net/shop/downloads/copperminesc-reloaded-pro/"><b>PRO</b></a>!</u></center>

    </div>
    <?php
}


